/*
	This is a part of the source code for Pro/DESKTOP.
	Copyright (C) 1998-1999 Parametric Technology Corporation.
	All rights reserved.
*/

//	DrawingClose.cpp

#include <stdafx.h>

#include "CUtility.h"
#include "CFile.h"
#include "CApplication.h"

//	Close the active Drawing
HRESULT DrawingClose() 
{

	START_METHOD("DrawingClose")

	HRESULT status = CONV_SUCCESS ;

	IApplication *pdApplication = NULL ;
	IDrawingDocument *activeDoc = NULL;
	
	// Get the application
	status = GetProDESKTOPApplication(&pdApplication) ;
	CHECK_RETURN_STATUS(status)

	IGraphicDocument *pActiveDoc = NULL;
	// get the application
	status = pdApplication->GetActiveDoc(&pActiveDoc);
	CHECK_RETURN_STATUS(status)

	activeDoc = CAST(IDrawingDocument, pActiveDoc);

	IGraphicDocument *activeGraphicDoc = CAST(IGraphicDocument, pActiveDoc);

	IDrawing *pDrawing = NULL;
	status = activeDoc->GetDrawing(&pDrawing);
	CHECK_RETURN_STATUS(status)

	IObject *object = CAST(IObject, pDrawing);

	IFile *pFile = NULL;
	status = object->GetFile(&pFile) ;
	CHECK_RETURN_STATUS(status)

	IFile *file = CAST(IFile, pFile);

	BSTR str;
	status = file->GetName(&str) ;
	CString fileName(str) ;

	IDrawingDocOthers *doc = CAST(IDrawingDocOthers, activeDoc);

	// close the drawing
	VARIANT_BOOL retval = FALSE;
	if(fileName.IsEmpty()) {
		status = activeGraphicDoc->Close(NULL, FALSE, &retval);
		CHECK_RETURN_STATUS(status)
	}
	else {
		status = activeGraphicDoc->Close(fileName.AllocSysString(), TRUE, &retval);
		CHECK_RETURN_STATUS(status)
	}
	END_METHOD("DrawingClose")

}
